/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.IntSupplier;
import net.coderbot.iris.JomlConversions;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.mixin.statelisteners.BooleanStateAccessor;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.texture.TextureTracker;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.coderbot.iris.uniforms.ExternallyManagedUniforms;
import net.coderbot.iris.uniforms.FogUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.HardcodedCustomUniforms;
import net.coderbot.iris.uniforms.IdMapUniforms;
import net.coderbot.iris.uniforms.IrisExclusiveUniforms;
import net.coderbot.iris.uniforms.IrisInternalUniforms;
import net.coderbot.iris.uniforms.MatrixUniforms;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.coderbot.iris.uniforms.ViewportUniforms;
import net.coderbot.iris.uniforms.WorldTimeUniforms;
import net.coderbot.iris.uniforms.transforms.SmoothedFloat;
import net.coderbot.iris.uniforms.transforms.SmoothedVec2f;
import net.coderbot.iris.vendored.joml.Vector2f;
import net.coderbot.iris.vendored.joml.Vector2i;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.coderbot.iris.vendored.joml.Vector4i;
import net.minecraft.class_1044;
import net.minecraft.class_1059;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5636;
import net.minecraft.class_746;
import net.minecraft.class_757;

public final class CommonUniforms {
    private static final class_310 client = class_310.method_1551();
    private static final Vector2i ZERO_VECTOR_2i = new Vector2i();
    private static final Vector4i ZERO_VECTOR_4i = new Vector4i(0, 0, 0, 0);
    private static final Vector3d ZERO_VECTOR_3d = new Vector3d();

    private CommonUniforms() {
    }

    public static void addCommonUniforms(DynamicUniformHolder dynamicUniformHolder, IdMap idMap, PackDirectives packDirectives, FrameUpdateNotifier frameUpdateNotifier, FogMode fogMode) {
        CameraUniforms.addCameraUniforms(dynamicUniformHolder, frameUpdateNotifier);
        ViewportUniforms.addViewportUniforms(dynamicUniformHolder);
        WorldTimeUniforms.addWorldTimeUniforms(dynamicUniformHolder);
        SystemTimeUniforms.addSystemTimeUniforms(dynamicUniformHolder);
        new CelestialUniforms(packDirectives.getSunPathRotation()).addCelestialUniforms(dynamicUniformHolder);
        IdMapUniforms.addIdMapUniforms(dynamicUniformHolder, idMap);
        IrisExclusiveUniforms.addIrisExclusiveUniforms(dynamicUniformHolder);
        MatrixUniforms.addMatrixUniforms(dynamicUniformHolder, packDirectives);
        HardcodedCustomUniforms.addHardcodedCustomUniforms(dynamicUniformHolder, frameUpdateNotifier);
        FogUniforms.addFogUniforms(dynamicUniformHolder, fogMode);
        IrisInternalUniforms.addFogUniforms(dynamicUniformHolder);
        dynamicUniformHolder.uniform2i("atlasSize", () -> {
            int n = RenderSystem.getShaderTexture((int)0);
            class_1044 class_10442 = TextureTracker.INSTANCE.getTexture(n);
            if (class_10442 instanceof class_1059) {
                TextureInfoCache.TextureInfo textureInfo = TextureInfoCache.INSTANCE.getInfo(n);
                return new Vector2i(textureInfo.getWidth(), textureInfo.getHeight());
            }
            return ZERO_VECTOR_2i;
        }, runnable -> {});
        dynamicUniformHolder.uniform4i("blendFunc", () -> {
            GlStateManager.class_1017 class_10172 = GlStateManagerAccessor.getBLEND();
            if (((BooleanStateAccessor)class_10172.field_5045).isEnabled()) {
                return new Vector4i(class_10172.field_5049, class_10172.field_5048, class_10172.field_5047, class_10172.field_5046);
            }
            return ZERO_VECTOR_4i;
        }, StateUpdateNotifiers.blendFuncNotifier);
        dynamicUniformHolder.uniform1i("renderStage", () -> GbufferPrograms.getCurrentPhase().ordinal(), StateUpdateNotifiers.phaseChangeNotifier);
        CommonUniforms.generalCommonUniforms(dynamicUniformHolder, frameUpdateNotifier, packDirectives);
    }

    public static void generalCommonUniforms(UniformHolder uniformHolder, FrameUpdateNotifier frameUpdateNotifier, PackDirectives packDirectives) {
        ExternallyManagedUniforms.addExternallyManagedUniforms117(uniformHolder);
        SmoothedVec2f smoothedVec2f = new SmoothedVec2f(packDirectives.getEyeBrightnessHalfLife(), packDirectives.getEyeBrightnessHalfLife(), CommonUniforms::getEyeBrightness, frameUpdateNotifier);
        uniformHolder.uniform1b(UniformUpdateFrequency.PER_FRAME, "hideGUI", () -> CommonUniforms.client.field_1690.field_1842).uniform1f(UniformUpdateFrequency.PER_FRAME, "eyeAltitude", () -> Objects.requireNonNull(client.method_1560()).method_23320()).uniform1i(UniformUpdateFrequency.PER_FRAME, "isEyeInWater", CommonUniforms::isEyeInWater).uniform1f(UniformUpdateFrequency.PER_FRAME, "blindness", CommonUniforms::getBlindness).uniform1i(UniformUpdateFrequency.PER_FRAME, "heldBlockLightValue", new HeldItemLightingSupplier(class_1268.field_5808)).uniform1i(UniformUpdateFrequency.PER_FRAME, "heldBlockLightValue2", new HeldItemLightingSupplier(class_1268.field_5810)).uniform1f(UniformUpdateFrequency.PER_FRAME, "nightVision", CommonUniforms::getNightVision).uniform1f(UniformUpdateFrequency.PER_FRAME, "screenBrightness", () -> CommonUniforms.client.field_1690.field_1840).uniform4f(UniformUpdateFrequency.ONCE, "entityColor", Vector4f::new).uniform1f(UniformUpdateFrequency.PER_TICK, "playerMood", CommonUniforms::getPlayerMood).uniform2i(UniformUpdateFrequency.PER_FRAME, "eyeBrightness", CommonUniforms::getEyeBrightness).uniform2i(UniformUpdateFrequency.PER_FRAME, "eyeBrightnessSmooth", () -> {
            Vector2f vector2f = smoothedVec2f.get();
            return new Vector2i((int)vector2f.x(), (int)vector2f.y());
        }).uniform1f(UniformUpdateFrequency.PER_TICK, "rainStrength", CommonUniforms::getRainStrength).uniform1f(UniformUpdateFrequency.PER_TICK, "wetness", new SmoothedFloat(packDirectives.getWetnessHalfLife(), packDirectives.getDrynessHalfLife(), CommonUniforms::getRainStrength, frameUpdateNotifier)).uniform3d(UniformUpdateFrequency.PER_FRAME, "skyColor", CommonUniforms::getSkyColor);
    }

    private static Vector3d getSkyColor() {
        if (CommonUniforms.client.field_1687 == null || CommonUniforms.client.field_1719 == null) {
            return ZERO_VECTOR_3d;
        }
        return JomlConversions.fromVec3(CommonUniforms.client.field_1687.method_23777(CommonUniforms.client.field_1719.method_19538(), CapturedRenderingState.INSTANCE.getTickDelta()));
    }

    static float getBlindness() {
        class_1293 class_12932;
        class_1297 class_12972 = client.method_1560();
        if (class_12972 instanceof class_1309 && (class_12932 = ((class_1309)class_12972).method_6112(class_1294.field_5919)) != null) {
            return Math.min(1.0f, (float)class_12932.method_5584() / 20.0f);
        }
        return 0.0f;
    }

    private static float getPlayerMood() {
        if (!(CommonUniforms.client.field_1719 instanceof class_746)) {
            return 0.0f;
        }
        return ((class_746)CommonUniforms.client.field_1719).method_26269();
    }

    static float getRainStrength() {
        if (CommonUniforms.client.field_1687 == null) {
            return 0.0f;
        }
        return CommonUniforms.client.field_1687.method_8430(CapturedRenderingState.INSTANCE.getTickDelta());
    }

    private static Vector2i getEyeBrightness() {
        if (CommonUniforms.client.field_1719 == null || CommonUniforms.client.field_1687 == null) {
            return ZERO_VECTOR_2i;
        }
        class_243 class_2432 = CommonUniforms.client.field_1719.method_19538();
        class_243 class_2433 = new class_243(class_2432.field_1352, CommonUniforms.client.field_1719.method_23320(), class_2432.field_1350);
        class_2338 class_23382 = new class_2338(class_2433);
        int n = CommonUniforms.client.field_1687.method_8314(class_1944.field_9282, class_23382);
        int n2 = CommonUniforms.client.field_1687.method_8314(class_1944.field_9284, class_23382);
        return new Vector2i(n * 16, n2 * 16);
    }

    private static float getNightVision() {
        float f;
        class_1297 class_12972 = client.method_1560();
        if (class_12972 instanceof class_1309) {
            class_1309 class_13092 = (class_1309)class_12972;
            try {
                float f2 = class_757.method_3174((class_1309)class_13092, (float)CapturedRenderingState.INSTANCE.getTickDelta());
                if (f2 > 0.0f) {
                    return f2;
                }
            }
            catch (NullPointerException nullPointerException) {
                return 0.0f;
            }
        }
        if (CommonUniforms.client.field_1724 != null && CommonUniforms.client.field_1724.method_6059(class_1294.field_5927) && (f = CommonUniforms.client.field_1724.method_3140()) > 0.0f) {
            return f;
        }
        return 0.0f;
    }

    static int isEyeInWater() {
        class_5636 class_56362 = CommonUniforms.client.field_1773.method_19418().method_19334();
        if (class_56362 == class_5636.field_27886) {
            return 1;
        }
        if (class_56362 == class_5636.field_27885) {
            return 2;
        }
        if (class_56362 == class_5636.field_27887) {
            return 3;
        }
        return 0;
    }

    static {
        GbufferPrograms.init();
    }

    private static class HeldItemLightingSupplier
    implements IntSupplier {
        private final class_1268 hand;

        private HeldItemLightingSupplier(class_1268 class_12682) {
            this.hand = class_12682;
        }

        @Override
        public int getAsInt() {
            if (CommonUniforms.client.field_1724 == null) {
                return 0;
            }
            class_1799 class_17992 = CommonUniforms.client.field_1724.method_5998(this.hand);
            if (class_17992 == class_1799.field_8037 || class_17992 == null || !(class_17992.method_7909() instanceof class_1747)) {
                return 0;
            }
            class_1747 class_17472 = (class_1747)class_17992.method_7909();
            return class_17472.method_7711().method_9564().method_26213();
        }
    }
}

